	subroutine mvkeenan(x,n,k,np,u1,u2,u3,ndf1,ndf2,pvaluee,
     +	pvaluec,pvaluef)
c
c***********************************************************************
c					    
c   FORTRAN subroutine to calculate the value of the test statistic
c   for the multivariate extension of Keenan's (1985) test for linearity
c   of a time series.
c
c   Input: x = a matrix of dimension n x k containing the multivariate
c              time series.
c          n = an integer containing the length of the time series (and
c              so the number of columns of x).
c          k = an integer containing the number of time series (and so
c              the number of rows of x).
c          np = an integer containing the order of the autoregressive
c               process.
c
c   Output: u = a double precision real scalar containing the value
c               of the test statistic.
c           ndf1 = an integer containing the numerator degrees of
c                  freedom.
c           ndf2 = an integer containing the denominator degrees of 
c                  freedom.
c           pvaluee = a double precision real scalar containing the
c                     p-value of the test statistic based on the exact
c                     distribution (a product of independent beta
c                     random variables.
c           pvaluec = a double precision real scalar containing the 
c                     p-value of the test statistic based on the chi-
c                     square approximation to the distribution.
c           pvaluef = a double precision real scalar containing the 
c                     p-value of the test statistic based on an F 
c                     distribution.  If p = 1 or 2 or if the number of
c                     non-linear terms in the non-linear model = 1 or
c                     2, the distribution is an exact F distribution.
c
c   Accuracy:  Implicit double precision (a-h,p-z)
c
c   Created: 8/05/97 Bonnie Ray
c   Subprograms called: udists, IMSL subroutines DRGIVN, 
c                       double precision function DMACH
c
c***********************************************************************
c
	parameter(nkmx = 5, nmx = 500, npmx = 10, nqmx = (npmx*nkmx)**2)
c												
	implicit double precision (a-h, p-z)
c
	double precision x(nmx,nkmx),xr(nmx,nkmx+npmx*nkmx)
	double precision xr2(nmx,nkmx+npmx*nkmx),xmin(npmx*nkmx)
	double precision xmax(npmx*nkmx)
	double precision yfit(nmx,nkmx),ssr(nkmx,nkmx)
	double precision b(npmx*nkmx,nkmx),ssy(nkmx,nkmx)
	double precision r(npmx*nkmx,npmx*nkmx)
	double precision d(npmx*nkmx),tempu(1),tstats(8)
	double precision sse(nkmx,nkmx) 
	double precision tempy(nmx,nkmx),tempx(nmx,nkmx*npmx)
	double precision sse2(nkmx,nkmx) 
c
	integer inddep1(nkmx) 
	integer indind(npmx*nkmx),indind2(nkmx)
c
c	external DRGIVN, DMACH, DGEMM, DLFTSF, DLFDSF
c
c   Initialize variables:
c
	ndf1 = 0
	ndf2 = 0
	u = 0.0d0
	pvaluee = 0.0d0
	pvaluec = 0.0d0
	pvaluef = 0.0d0
c
c   Set up the X matrix for the regressions in steps one and two of the
c   test.
c
c   xr contains "data matrix"; xr is [X_t|X_{t-1},...,X_{t-p}] is
c   used for the first regression and  
c
c   tempx contains the matrix of "independent" variables; that is,
c   tempx = [X_{t-1}, ... ,X_{t-p}].
c
c
c
	do i = 1,n-np
		do j = 0,np
			do l = 1,k
			   xr(i,k*j+l) = x(i+np-j,l)
	              if (j .gt. 0) tempx(i,k*(j-1)+l)=x(i+np-j,l)
			enddo
	        enddo
	enddo
c
c   Perform k-variate AR(np) regression of x on xr.  IMSL subroutine
c   DRGIVN is used to perform calculations.
c
c   DRGIVN is a double precision IMSL subroutine used to fit a 
c   multivariate linear regression model via fast Givens transformation.
c
c   indind is a vector of indices required by DRGIVN.  indind contains
c   the column numbers of xr that are the independent variables.  
c   indind must be of length np*k.
c
c   inddep1 is a vector of indices required by DRGIVN.  inddep1 is of
c   length k containing the column numbers of xr that are the
c   dependent variables.
c
	do i = 1,np*k
		indind(i) = k+i
	enddo
	do i = 1,k
		inddep1(i) = i
	enddo
c
c   DRGIVN will return the following:
c    b = np*k x k matrix containing least squares solution.
c    r = np*k x np*k upper triangular matrix containing the "R" matrix
c        from a QR decomposition of the matrix of regressors.  Since the
c        first argument passed to DRGIVN has a value of 0, the matrix
c        of raw sums of squares and crossproducts for the regressors
c        can be found as r*t*diag(d)*r where diag(d) is the diagonal
c        matrix whose diagonal elements are the elements of the vector
c        d.
c     d = vector of length np*k containing scale factors for fast 
c         Givens transformations.  Since the first argument passed to 
c         DRGIVN has a value of 0, each element of d is 1.0d0.
c     irank = the rank of r.
c     dfe = degrees of freedom for error.
c     sse = k x k matrix containing residual sums of squares and
c           crossproducts.  sse(m,n) contains the current sums of
c           crossproducts of residuals for the mth and nth dependent
c           variables.
c     nrmiss = number of rows of data encountered that contained any
c              missing values.
c     xmin = a vector of length np*k containing the minimum values
c            for each of the regressors.
c     xmax = a vector of length np*k containing the maximum values 
c            for each of the regressors.
c
c    
c    
	call DRGIVN(0,n-np,k*(np+1),xr,nmx,0,np*k,indind,k,inddep1,
     +    0,0,0,100*DMACH(4),b,npmx*nkmx,r,npmx*nkmx,d,irank,dfe,sse,
     +    nkmx,nrmiss,xmin,xmax)
c
c  Compute square of fitted values from linear k-variate AR regression and store 
c  in the xr for next regression.
c
c  The IMSL subroutine DGEMM is used to performs these calculations.
c  DGEMM assigns the matrix yfit <- 1.0d0*tempx*b + 0.0d0*yfit.  The
c  first arguments passed to DGEMM indicate to not take the transpose
c  of tempx and b, respectively. The remaining arguments are defined
c  as follows:
c     n - np = number of columns of tempx
c     np*k = number of rows  of rows of b.  
c     k = number of columns of b.
c     nmx = leading dimension of tempx.
c     npmx*nkmx = leading dimension of b.
c     nmx = leading dimension of yfit.
c
	call DGEMM('N','N',n-np,k,np*k,1.0d0,tempx,nmx,b,npmx*nkmx,0.0d0,
     +	yfit,nmx)
	 do i=1,n-np
	   do j=1,k
	      xr2(i,j)=xr(i,j)-yfit(i,j) !Residuals
	      tempy(i,j)=xr2(i,j)	     ! Residuals again
	      xr(i,j)=yfit(i,j)**2.0d0   !Square of fits
	   enddo
      enddo
c
c   Perform regression two of squared fitted values.  
c
	call DRGIVN(0,n-np,k+np*k,xr,nmx,0,np*k,indind,k,inddep1,
     +	0,0,0,100*DMACH(4),b,npmx*nkmx,r,npmx*nkmx,d,irank,dfe,
     +	sse2,nkmx,nrmiss,xmin,xmax)
c
c   Compute residuals for the second regression and store them in the
c   matrix xr2:
c
c   DGEMM is used for this too.
c
	call DGEMM('N','N',n-np,k,np*k,1.0d0,tempx,nmx,b,npmx*nkmx,
     +	0.0d0,yfit,nmx)
c
	do i = 1,n-np
	do j = 1,k
		xr2(i,k+j) = xr(i,j) -yfit(i,j)
	enddo
	enddo
c
c   Begin step three:  regression of residuals from first regression
c   (contained in the first k columns of xr2) on the residuals of
c   the second regression (contained in the k+1 through k+k columns
c   of xr2).  
c
c   DRGIVN is invoked again.  In this call to DRGIVN, sse is the
c   k x k matrix containing the (regression 3) residual sums of squares
c   and cross-products.  The determinant of SSE = sse is used in the
c   denominator of the test statistic.
c
	do i = 1,k
		indind2(i) = k+i
	enddo
c
	call DRGIVN(0,n-np,k+k,xr2,nmx,0,k,indind2,k,inddep1,0,0,0,
     +	100*dmach(4),b,nkmx*npmx,r,nkmx*npmx,d,irank,dfe,sse,nkmx,
     +	nrmiss,xmin,xmax)
c
c   This call to DMXTF multiplies the residuals from the first
c   regression by themselves to get total sum of squares for the
c   third regression.
c   
	call DMXTXF(n-np,k,tempy,nmx,k,ssy,nkmx)
c
c   Calculate matrix of sum of squared and crossproduct terms for 
c   regression using relationship SSY = SSReg + SSE.  
c
	do i = 1,k
	do j = 1,k
		ssr(i,j) = ssy(i,j) - sse(i,j)
	enddo
	enddo
c
	ndf2=(n-np-np*k)-k
	ndf1=k
      CALL DRHPTE(dble(ndf2),k,sse,nkmx,0,tempu,1,dble(ndf1),ssr, 
     +       nkmx,tstats)

      u1=tstats(1)
	u2=tstats(3)
	u3=tstats(4)
      pvaluee=tstats(5)
	pvaluec=tstats(7)
	pvaluef=tstats(8)

	
	return
	end